from tensorflow import keras
import tensorflow as tf

import pandas as pd
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 12})

import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix
from sklearn.preprocessing import StandardScaler,LabelEncoder
import tensorflow.keras
from keras.utils import np_utils
from CNNmodels import *
from confusion_matrix_2 import *

# creat check point
os.getcwd()
os.chdir(r'../models')
checkpoint_filepath = '/checkpoint'
print(checkpoint_filepath)

checkpoint = ModelCheckpoint(filepath='checkpoint_60dB_CNN_C', 
                             monitor='val_acc',
                             verbose=1,
                             save_best_only='True',
                             mode='max',
                             period=1)

df=pd.read_csv(r"../finalallyan60.txt")
df=df.drop(columns= 'Unnamed: 0')
labelencoder = LabelEncoder()
df['Labels'] = labelencoder.fit_transform(df['damage'])
labels=df["Labels"]
dummy_labels = np_utils.to_categorical(labels)
y=dummy_labels
features = df.iloc[:,2:-1]
X=features
X_train_full, X_test_full, y_train, y_test = train_test_split(X, y, test_size=0.2, shuffle=True)
scaler = StandardScaler()
X_train = scaler.fit_transform(X_train_full)
mean_value=scaler.mean_
std_dev_value=scaler.scale_
# print(f"Training set normalization parameters\nMean values:\n{mean_value}\nStd Dev values:\n{std_dev_value}")
X_test = scaler.transform(X_test_full)
#  To save the Scaler model to use later

model = CNN_model_C()
# model =model_A() /model_B()

callback_lists = [checkpoint]  
model_m.compile(loss="categorical_crossentropy", optimizer='adam', metrics=['acc'])#, metrics=['mean_squared_error'])
history =model_m.fit(X_train,y_train,batch_size=200,epochs=1000,shuffle='True',verbose=1,callbacks=callback_lists,validation_split = 0.10)

#time history figure
plt.rcParams.update({'font.size': 14})
pd.DataFrame(history.history).plot(figsize=(7, 6))
plt.grid(True)
plt.xlabel("Epochs")
plt.ylabel("Loss")
# plt.gca().set_ylim(0, 1) # set the vertical range to [0-1]
#plt.savefig("training.jpg")
plt.show()


# predict on test dataset
reconstructed_model = keras.models.load_model(r"../checkpoint_60dB_CNN_C")
model = reconstructed_model
y_pred = model.predict(X_test)
# y_pred=(y_pred >0.5)
y_pred=(y_pred == y_pred.max(axis = 1)[: , None]).astype(int)
y_true=y_test

# plot and save the confusion matrix
plot_confusion()